//	CDialogPrefs.c

#ifndef _H_CDialogPrefs
#define _H_CDialogPrefs

#include "CDialog.h"

enum {
	kPref_NONE, 
	
	kPref_DETOKENIZE_CHECK, 
	kPref_DETOKENIZE_VERB, 
	kPref_SHOW_PROG_AFTER_POP, 
	kPref_ENABLE_LOGGING_CHECK, 
	kPref_LOG_UPDATES_CHECK, 
	kPref_LOG_MEMORY_CHECK, 
	kPref_RED_BACKGROUNDS_CHECK, 
	kPref_BW_SCREEN_CHECK, 
	
	kPref_NUMTYPES
};

enum {
	DPrf_ItemStr_DETOKENIZE_VERB,
	DPrf_ItemStr_NUMTYPES
};
typedef short	DPrf_ItemStrType;

enum {
	kPref_MID_ShowProgAfter_NONE, 
	
	kPref_MID_ShowProgAfter_0, 
	kPref_MID_ShowProgAfter_1, 
	kPref_MID_ShowProgAfter_2, 
	kPref_MID_ShowProgAfter_3, 
	kPref_MID_ShowProgAfter_5, 
	kPref_MID_ShowProgAfter_8, 
	kPref_MID_ShowProgAfter_10, 
	kPref_MID_ShowProgAfter_NEVER, 
	
	kPref_MID_ShowProgAfter_NUMTYPES
};

/***************************************/

class CDialogPrefs;

CDialogPrefs	*ShowPrefsDialog(void);
void			HidePrefsDialog(void);
WindowRef		GetPrefsWindow(void);

void			SetPrefDepth(void);
void			RestoreOrigDepth(void);

ulong		ProgressDelayMenuToTicks(ushort menuID);

class CDialogPrefs : public CDialog {

	public:		Boolean		IDialogPrefs(void);
	virtual		void		Dispose(void);
	
	virtual		void		DoClick(EventRecord *event);
	virtual		void		DoKeyDown(EventRecord *event);
	virtual		void		Move(EventRecord *event);
	
	virtual		void		DialogItemStandardDrawProc(
		DialogItemIndex	itemNo,
		Rect			*itemRectP);

	void		ValueConvert(
		DGI_ValueConvertType	convertType, 
		short					dlgItem);

	virtual	void		UpdateMenus(void);
	virtual	Boolean		DoCommand(long command);
	
	/******************************************/
	DGI_ItemRec		i_itemStrTable[DPrf_ItemStr_NUMTYPES];

	typedef		 	CDialog		_inherited;
};

#endif